/*
 * Decompiled with CFR 0.152.
 */
package ru.den.autoinstaller;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lru/den/autoinstaller/Setup;", "", "()V", "Companion", "autoinstall"})
public final class Setup {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void main(@NotNull String[] args2) throws IOException {
        Companion.main(args2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u001b\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lru/den/autoinstaller/Setup$Companion;", "", "()V", "changeApache2Conf", "", "changeConfFirstInstall", "domName", "", "useHttps", "", "clearDirectory", "dir", "Ljava/io/File;", "createHtAccessHttps", "mainPath", "larPath", "createUpdateScript", "main", "args", "", "([Ljava/lang/String;)V", "autoinstall"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final void changeApache2Conf() {
            Path path = Paths.get("/etc/apache2/apache2.conf", new String[0]);
            List<String> lines = Files.readAllLines(path);
            boolean enableScan = false;
            int n = 0;
            List<String> list = lines;
            Intrinsics.checkNotNullExpressionValue(list, "lines");
            int n2 = ((Collection)list).size();
            while (n < n2) {
                void i;
                if (!enableScan) {
                    String string = lines.get((int)i);
                    Intrinsics.checkNotNullExpressionValue(string, "lines[i]");
                    if (StringsKt.contains$default((CharSequence)string, "<Directory /var/www/>", false, 2, null)) {
                        enableScan = true;
                    }
                } else {
                    String string = lines.get((int)i);
                    Intrinsics.checkNotNullExpressionValue(string, "lines[i]");
                    if (StringsKt.contains$default((CharSequence)string, "Require all", false, 2, null)) {
                        lines.set((int)i, "        Require all granted");
                        break;
                    }
                }
                ++i;
            }
            Files.write(path, (Iterable<? extends CharSequence>)lines, Charset.defaultCharset(), new OpenOption[0]);
        }

        private final void clearDirectory(File dir) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                File file2 = file = fileArray[i];
                Intrinsics.checkNotNullExpressionValue(file2, "file");
                if (file2.isDirectory()) {
                    this.clearDirectory(file);
                }
                file.delete();
            }
        }

        private final void changeConfFirstInstall(String domName, boolean useHttps) {
            String path1 = "/etc/apache2/sites-available";
            String path2 = "/etc/apache2/sites-enabled";
            this.clearDirectory(new File(path1));
            this.clearDirectory(new File(path2));
            ArrayList<String> lines = new ArrayList<String>();
            if (useHttps) {
                lines.add("<VirtualHost _default_:443>");
                lines.add("        SSLEngine on");
                lines.add("        ServerName    " + domName);
                lines.add("        SSLCertificateFile /etc/ssl/domain_name.crt");
                lines.add("        SSLCertificateKeyFile /etc/ssl/private.key");
                lines.add("        SSLCertificateChainFile /etc/ssl/chain.crt");
                lines.add("        ServerAdmin     webmaster@" + domName);
                lines.add("        DocumentRoot    /var/www/html");
                lines.add("        DocumentRoot    /var/www/html");
                lines.add("        DirectoryIndex  index.php index.html index.htm");
                lines.add("        ErrorLog        /var/log/apache2/err.log." + domName);
                lines.add("        <Directory /var/www/html>");
                lines.add("                Options Indexes FollowSymLinks");
                lines.add("                AllowOverride All");
                lines.add("                Require all granted");
                lines.add("        </Directory>");
                lines.add("</VirtualHost>");
            }
            lines.add("<VirtualHost _default_:80>");
            lines.add("        ServerAdmin     webmaster@" + domName);
            lines.add("        ServerName      " + domName);
            lines.add("        DocumentRoot    /var/www/html");
            lines.add("        DirectoryIndex  index.php index.html index.htm");
            lines.add("        ErrorLog        /var/log/apache2/err.log." + domName);
            lines.add("        <Directory /var/www/html>");
            lines.add("              Options Indexes FollowSymLinks");
            lines.add("              AllowOverride All");
            lines.add("              Require all granted");
            lines.add("        </Directory>");
            lines.add("</VirtualHost>");
            Files.write(Paths.get(path1 + '/' + domName + ".conf", new String[0]), (Iterable<? extends CharSequence>)lines, Charset.defaultCharset(), new OpenOption[0]);
            Files.write(Paths.get(path2 + '/' + domName + ".conf", new String[0]), (Iterable<? extends CharSequence>)lines, Charset.defaultCharset(), new OpenOption[0]);
        }

        private final void createHtAccessHttps(boolean useHttps, String mainPath, String larPath) {
            ArrayList<String> lines = new ArrayList<String>();
            if (useHttps) {
                lines.add("RewriteEngine On");
                lines.add("RewriteCond %{SERVER_PORT} !^443$");
                lines.add("RewriteRule .* https://%{SERVER_NAME}%{REQUEST_URI} [R=301,L]");
            }
            lines.add("<IfModule mod_rewrite.c>");
            lines.add("    RewriteEngine On");
            lines.add("    RewriteRule ^(.*)$ " + mainPath + '/' + larPath + "/public/$1 [L]");
            lines.add("</IfModule>");
            String path = "/var/www/html/.htaccess";
            new File(path).delete();
            Files.write(Paths.get(path, new String[0]), (Iterable<? extends CharSequence>)lines, Charset.defaultCharset(), new OpenOption[0]);
        }

        private final void createUpdateScript(String mainPath, String larPath) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("# chmod +x update.sh");
            lines.add("cd /var/www/html/" + mainPath + '/');
            lines.add("git reset --hard");
            lines.add("git pull --all");
            lines.add("cd " + larPath);
            lines.add("php artisan migrate");
            lines.add("php artisan storage:link");
            String path = "/var/www/html/update.sh";
            new File(path).delete();
            Files.write(Paths.get(path, new String[0]), (Iterable<? extends CharSequence>)lines, Charset.defaultCharset(), new OpenOption[0]);
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) throws IOException {
            boolean bl;
            boolean bl2;
            String[] stringArray;
            String larPath;
            String mainPath;
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter(args2, "args");
                    String string = "\u0437\u0430\u043f\u0443\u0441\u043a \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a\u0430 ateuco.online - ok.";
                    boolean bl3 = false;
                    System.out.println((Object)string);
                    if (Intrinsics.areEqual("Linux", System.getProperty("os.name")) ^ true) {
                        string = "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0432 \u043b\u0438\u043d\u0443\u043a\u0441 Ubuntu - err.";
                        bl3 = false;
                        System.out.println((Object)string);
                        return;
                    }
                    string = "\u0437\u0430\u043f\u0443\u0441\u043a \u0438\u0437 Linux - ok.";
                    bl3 = false;
                    System.out.println((Object)string);
                    if (!ArraysKt.contains(args2, "-https")) {
                        string = "\u0432\u044b \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u043b\u0438 \u0431\u0435\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 -https";
                        bl3 = false;
                        System.out.println((Object)string);
                    } else {
                        string = "\u0432\u044b \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u043b\u0438 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u043c -https, \u043d\u0435 \u0437\u0430\u0431\u0443\u0434\u044c\u0442\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 /etc/ssl/domain_name.crt, /etc/ssl/private.key, /etc/ssl/chain.crt";
                        bl3 = false;
                        System.out.println((Object)string);
                    }
                    if (!new File("vps-install.sh").exists()) {
                        string = "\u0444\u0430\u0439\u043b vps-install \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u0440\u0430\u0431\u043e\u0442\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430";
                        bl3 = false;
                        System.out.println((Object)string);
                        return;
                    }
                    List<String> installLines = Files.readAllLines(Paths.get("vps-install.sh", new String[0]));
                    mainPath = "";
                    larPath = "";
                    for (String[] stringArray2 : installLines) {
                        Intrinsics.checkNotNullExpressionValue(stringArray2, "line");
                        if (StringsKt.startsWith$default((String)stringArray2, "main_path", false, 2, null)) {
                            stringArray = stringArray2;
                            bl2 = false;
                            mainPath = StringsKt.replace$default(StringsKt.replace$default(((Object)StringsKt.trim((CharSequence)stringArray)).toString(), "main_path=\"", "", false, 4, null), "\";", "", false, 4, null);
                            continue;
                        }
                        if (!StringsKt.startsWith$default((String)stringArray2, "lar_path", false, 2, null)) continue;
                        stringArray = stringArray2;
                        bl2 = false;
                        larPath = StringsKt.replace$default(StringsKt.replace$default(((Object)StringsKt.trim((CharSequence)stringArray)).toString(), "lar_path=\"", "", false, 4, null), "\";", "", false, 4, null);
                    }
                    CharSequence charSequence = mainPath;
                    bl = false;
                    if (charSequence.length() == 0) break block9;
                    CharSequence charSequence2 = larPath;
                    bl = false;
                    if (!(charSequence2.length() == 0)) break block10;
                }
                String string = "\u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 mainPath \u0438\u043b\u0438 larPath \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0432 \u0444\u0430\u0439\u043b\u0435 vps-install";
                bl = false;
                System.out.println((Object)string);
                return;
            }
            this.changeApache2Conf();
            String[] stringArray3 = args2;
            bl = false;
            stringArray = stringArray3;
            bl2 = false;
            this.changeConfFirstInstall(!(stringArray.length == 0) && Intrinsics.areEqual(args2[0], "-https") ^ true ? args2[0] : "default.ru", ArraysKt.contains(args2, "-https"));
            this.createHtAccessHttps(ArraysKt.contains(args2, "-https"), mainPath, larPath);
            this.createUpdateScript(mainPath, larPath);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

